/*
 * Decompiled with CFR 0.152.
 */
package com.category.domain;

import com.category.domain.model.ProductCategory;
import com.category.domain.use_case.product_category.AddProductCategory;
import com.category.domain.use_case.product_category.BatchInsertProductCategories;
import com.category.domain.use_case.product_category.FilterExistingProductCats;
import com.category.domain.use_case.product_category.GetCategoriesPerProduct;
import com.category.domain.use_case.product_category.GetProductCategories;
import com.google.gson.Gson;
import com.utility.ConvertStr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class ProductCategoryService {
    @Resource
    @Lazy
    private GetCategoriesPerProduct getCategoriesPerProduct;
    @Resource
    @Lazy
    private GetProductCategories getProductCategories;
    @Resource
    @Lazy
    private FilterExistingProductCats filterExistingProductCats;
    @Resource
    @Lazy
    private BatchInsertProductCategories batchInsertPCategories;
    @Resource
    @Lazy
    private AddProductCategory addProductCategory;

    public Map<String, List<Map<String, Object>>> getCategoriesPerProduct(String sqlWhere, @Nullable String commaSeparatedACodes) {
        return this.getCategoriesPerProduct.invoke(sqlWhere, commaSeparatedACodes);
    }

    public List<Map<String, Object>> getProductCategories(HttpServletRequest request) {
        return this.getProductCategories.invoke(request, null);
    }

    public ResponseEntity<?> postSmartHelpProductCategories(byte[] zippedBody) {
        String body = ConvertStr.deCompressionGZip((byte[])zippedBody);
        body = body.substring(14, body.length() - 1);
        Gson gson = new Gson();
        ProductCategory[] items = (ProductCategory[])gson.fromJson(body, ProductCategory[].class);
        return ConvertStr.getMapResponseEntity((String)"Poshak", new ArrayList(), (List)this.batchInsertPCategories.invoke(Arrays.asList(items)));
    }
}

